# Class Assignment Objective

This notebook explains the properties of different class assignment objectives available for the
machine learning data frame analytics classification jobs and give pointers on when to
choose which loss function.

Set up a local instance of Jupyter using the following instructions

1. Create file `credentials.json` containing the username and password to access your Elasticsearch instance.

    ```json
    {
        "username": "my_username",
        "password": "my_password"
    }
    ```

2. Set up a virtual environment called `env`

    ```bash
    python3 -m venv env
    ```

3. Activate it

    ```bash
    source env/bin/activate
    ```

4. Install the required dependencies for your chosen Jupyter notebook

    ```bash
    pip install -r requirements.txt
    ```

5. Launch Jupyter

    ```bash
    jupyter notebook
    ```
